/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.GeometryArray;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.QuadArrayRetained;

public class QuadArray
extends GeometryArray {
    QuadArray() {
    }

    public QuadArray(int n2, int n3) {
        super(n2, n3);
        if (n2 < 4 || n2 % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("QuadArray0"));
        }
    }

    public QuadArray(int n2, int n3, int n4, int[] nArray) {
        super(n2, n3, n4, nArray);
        if (n2 < 4 || n2 % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("QuadArray0"));
        }
    }

    public QuadArray(int n2, int n3, int n4, int[] nArray, int n5, int[] nArray2) {
        super(n2, n3, n4, nArray, n5, nArray2);
        if (n2 < 4 || n2 % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("QuadArray0"));
        }
    }

    void createRetained() {
        this.retained = new QuadArrayRetained();
        this.retained.setSource(this);
    }

    public NodeComponent cloneNodeComponent() {
        QuadArrayRetained quadArrayRetained = (QuadArrayRetained)this.retained;
        int n2 = quadArrayRetained.getTexCoordSetCount();
        int[] nArray = null;
        int n3 = quadArrayRetained.getVertexAttrCount();
        int[] nArray2 = null;
        if (n2 > 0) {
            nArray = new int[quadArrayRetained.getTexCoordSetMapLength()];
            quadArrayRetained.getTexCoordSetMap(nArray);
        }
        if (n3 > 0) {
            nArray2 = new int[n3];
            quadArrayRetained.getVertexAttrSizes(nArray2);
        }
        QuadArray quadArray = new QuadArray(quadArrayRetained.getVertexCount(), quadArrayRetained.getVertexFormat(), n2, nArray, n3, nArray2);
        quadArray.duplicateNodeComponent(this);
        return quadArray;
    }
}

